attribute vec4 position; //drawcall
attribute vec3 normal;    //drawcall
uniform mat4 view;         //common
uniform mat4 proj;         //common
varying vec3 n; 

void main()
{	
	vec3 pos = position.xyz; 
	gl_Position = proj*view*vec4(pos.xyz*200., 1.0);
	n = normalize(normal.xyz); 
  
}	

//FRAGMENT
varying vec3 n;  
uniform samplerCube Texture0;
uniform samplerCube Texture1; 
uniform float exponent;
uniform float tracks[32];

void main()
{
   vec4 c = textureCube(Texture1, normalize(n.xyz));
   vec4 s = textureCube(Texture1, normalize(n.xyz)); //spec

   gl_FragColor = tracks[24]*pow(s, exponent); 
}